using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using BLOODUNIT = gov.va.med.vbecs.Common.VbecsTables.BloodUnit;

namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI dialog allowing users to select multiple units for modification
		///</summary>

		#endregion


	public class DlgSelectMultipleUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{


		#region Variables

		/// <summary>
		/// Our control class
		/// </summary>
		private BOL.BloodUnitModification _bumControl;

		/// <summary>
		/// We don't create our ModificationController until the end, so we need to store
		/// the values until then. This will be a hashtable, containing a bloodunitguid, and an array of exceptions for that guid
		/// </summary>
		private System.Collections.Hashtable _exceptionsTable = new Hashtable();

		private bool _needsRefresh = false;

		private bool _avoidClicking = false;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.WorklistBuilder worklistBuilder1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Destructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// DlgSelectMultipleUnits constructor
		/// </summary>
		public DlgSelectMultipleUnits(BOL.BloodUnitModification bumControl)
		{
			this._bumControl = bumControl;
			//
			InitializeComponent();
			//
			SetComponentProperties();
			//
			if (this._bumControl.IsPool)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgSelectMultipleUnits());
			}
			else if (this._bumControl.IsSplit)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgSelectMultipleUnits());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC026.DlgSelectMultipleUnits());
			}
			//
			this.CheckValid(this, System.EventArgs.Empty);
		}
		
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.worklistBuilder1 = new gov.va.med.vbecs.GUI.controls.WorklistBuilder(this.components);
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(616, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 421);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// worklistBuilder1
			// 
			this.worklistBuilder1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.worklistBuilder1.CheckBoxes = true;
			this.worklistBuilder1.Location = new System.Drawing.Point(0, 32);
			this.worklistBuilder1.Name = "worklistBuilder1";
			this.worklistBuilder1.Size = new System.Drawing.Size(616, 376);
			this.worklistBuilder1.TabIndex = 0;
			this.worklistBuilder1.InvalidWorklist += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ValidWorklist += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.SelectBtnClick += new System.EventHandler(this.worklistBuilder1_SelectBtnClicked);
			this.worklistBuilder1.SearchClick += new System.EventHandler(this.worklistBuilder1_SearchClick);
			this.worklistBuilder1.UnitsInList += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ItemCheck += new System.EventHandler(this.worklistBuilder1_ItemCheck);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(456, 412);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(536, 412);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			// 
			// DlgSelectMultipleUnits
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(616, 437);
			this.KeyDownSpeakMessage += new KeyDownSpeakMessageEventHandler(DlgSelectMultipleUnits_KeyDownSpeakMessage); // **** 508 Compliance ***
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.worklistBuilder1);
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
		
			this.MinimumSize = new System.Drawing.Size(624, 464);
			this.Name = "DlgSelectMultipleUnits";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Select Units";
			this.Controls.SetChildIndex(this.worklistBuilder1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties


		/// <summary>
		/// Creates an array of the selected bloodunitguids
		/// </summary>
		public System.Collections.ArrayList SelectedBloodUnitsList
		{
			get
			{
				System.Collections.ArrayList tmpArray = new System.Collections.ArrayList();

				foreach(System.Data.DataRow dr in this.worklistBuilder1.SelectedBloodBags.Rows)
				{
					tmpArray.Add((System.Guid)dr[BLOODUNIT.BloodUnitGuid]);
				}
				return(tmpArray);
			}
		}

		/// <summary>
		/// Returns the collection of bumControls for non-pooling, multiple modification requests
		/// </summary>
		public System.Collections.ArrayList BumControlList
		{
			get
			{
				System.Collections.ArrayList bumList = new System.Collections.ArrayList();

				//This hopefully means that all the validations have been done already...
				foreach(System.Data.DataRow dr in this.worklistBuilder1.SelectedBloodBags.Rows)
				{
					BOL.BloodUnitModification bumControl = new BOL.BloodUnitModification(this._bumControl.ProductModificationCode, this._bumControl.ModificationMethod, this._bumControl.ModificationDateTime, this._bumControl.ModificationTechId);
					
					bumControl.ModifyUnit((System.Guid)dr[BLOODUNIT.BloodUnitGuid]);

					if (this._exceptionsTable.Contains(bumControl.OriginalUnit.BloodUnitGuid))
					{
						bumControl.Exceptions = (System.Collections.ArrayList)this._exceptionsTable[bumControl.OriginalUnit.BloodUnitGuid];
					}

					bumList.Add(bumControl);
				}				

				return(bumList);
			}
		}

		#endregion

		#region Methods/Functions

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Select Unit(s)";
			this.toolTip1.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
		}

		/// <summary>
		/// Throw messageboxes at the user based on Business Rule Validations
		/// Can I put this as a static method in the DlgModifyUnit class?
		/// </summary>
		/// <param name="testBloodUnit"></param>
		/// <param name="actionList">List of actions to take based on Unit Validation</param>
		private void ProcessActionItems(BOL.BloodUnit testBloodUnit, System.Collections.ArrayList actionList)
		{
			this._needsRefresh = false;

			//If there's nothing in our actionList, that means the selected unit was valid, and we move on
			if (actionList.Count == 0)
				return;
			
			for (int ndx=0; ndx < actionList.Count; ndx++)
			{
				Common.ActionItem dothis = (Common.ActionItem)actionList[ndx];

				if (dothis.ReturnAction == Common.VerifyAction.Cancel)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(dothis.Message));
					throw new BOL.BusinessObjectException(string.Empty);
				}

				//Unit is biohazardous and and override is required
				if (dothis.ReturnAction == Common.VerifyAction.OverrideBiohazard)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(dothis.Message)) == DialogResult.Yes)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
						{
							DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(testBloodUnit, dothis.Message);

                            dlgExpire.ShowDialogFromLockedParent(this, false);

							if (dlgExpire.DialogResult == DialogResult.OK)
							{
								System.Collections.ArrayList exceptionArray = new ArrayList();

								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Biohazardous_unit_modified, dlgExpire.Comment , Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionUnitModification(testBloodUnit, this._bumControl, DateTime.MinValue, null);
								if (this._exceptionsTable.ContainsKey(testBloodUnit.BloodUnitGuid))
								{
									exceptionArray = (System.Collections.ArrayList)this._exceptionsTable[testBloodUnit.BloodUnitGuid];
									exceptionArray.Add(exRep);
									this._exceptionsTable[testBloodUnit.BloodUnitGuid] = exceptionArray;
								}
								else
								{
									exceptionArray.Add(exRep);
									this._exceptionsTable.Add(testBloodUnit.BloodUnitGuid, exceptionArray);
								}
							}
							else
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
								throw new BOL.BusinessObjectException(string.Empty);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				//Unit is expired and an override is required
				if (dothis.ReturnAction == Common.VerifyAction.OverrideExpiration)
				{
					if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
					{
						DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(testBloodUnit, dothis.Message);

                        dlgExpire.ShowDialogFromLockedParent(this, false);
						if (dlgExpire.DialogResult == DialogResult.OK)
						{
							System.Collections.ArrayList exceptionArray = new ArrayList();

							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_unit_modified, dlgExpire.Comment , Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionUnitModification(testBloodUnit, this._bumControl, DateTime.MinValue, null);
							if (this._exceptionsTable.ContainsKey(testBloodUnit.BloodUnitGuid))
							{
								exceptionArray = (System.Collections.ArrayList)this._exceptionsTable[testBloodUnit.BloodUnitGuid];
								exceptionArray.Add(exRep);
								this._exceptionsTable[testBloodUnit.BloodUnitGuid] = exceptionArray;
							}
							else
							{
								exceptionArray.Add(exRep);
								this._exceptionsTable.Add(testBloodUnit.BloodUnitGuid, exceptionArray);
							}
						}
						else
						{
							//They've cancelled on the override, so this seems friendly enough, right?
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				if (dothis.ReturnAction == Common.VerifyAction.Release)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(dothis.Message)) == DialogResult.Yes)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.ReleaseBloodproductsFromQuarantine))
						{
							FrmDiscardQuarantine frmDQ = new FrmDiscardQuarantine(testBloodUnit);

                            frmDQ.ShowDialogFromLockedParent(this, true);
							if (frmDQ.DialogResult == DialogResult.Cancel)
							{								
								//They've cancelled on the override, so this seems friendly enough, right?
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
								throw new BOL.BusinessObjectException(string.Empty);
							}
							else
							{
								//Double-check to make sure they didn't do something else in UC27 -- 
								BOL.BloodUnitStatus unitStatus = new BOL.BloodUnitStatus(testBloodUnit.BloodUnitGuid);
								if (unitStatus.QuarantineIndicator)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
									throw new BOL.BusinessObjectException(string.Empty);
								}

								//Unit has changed, set the refresh flag
								this._needsRefresh = true;
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}


				if (dothis.ReturnAction == Common.VerifyAction.Warning)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(dothis.Message));
				}

			}//for
		}

		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Worklist builder control validity event handler, enables OK button when at least one unit is selected
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			string _message = String.Empty;

			if (this._bumControl.IsPool)
			{
				btnOK.EnabledButton = (this.worklistBuilder1.SelectedItems > 1);
				_message = (btnOK.EnabledButton) ? String.Empty : Common.StrRes.Tooltips.UC026.MustSelectXUnitsToContinue(2,"units").ResString;
			}
			else
			{
				btnOK.EnabledButton = (this.worklistBuilder1.SelectedItems > 0);
				_message = (btnOK.EnabledButton) ? String.Empty : Common.StrRes.Tooltips.UC026.MustSelectXUnitsToContinue(1,"unit").ResString;
			}

			btnOK.SetToolTip(_message);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, closes dialog with OK result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			//Build our exceptions that were created in ProcessActionItems
			if (this._bumControl.IsPool)
			{
				this._bumControl.Exceptions.Clear();

				foreach(BOL.BloodUnit poolingUnit in this.worklistBuilder1.SelectedBloodUnits)
				{
					IDictionaryEnumerator tmpEnum = this._exceptionsTable.GetEnumerator();

					while (tmpEnum.MoveNext())
					{
						if ((System.Guid)tmpEnum.Key == poolingUnit.BloodUnitGuid)
						{
							System.Collections.ArrayList arrayExceptions = (System.Collections.ArrayList)tmpEnum.Value;

							foreach(BOL.ExceptionReport unitException in arrayExceptions)
							{
								this._bumControl.Exceptions.Add(unitException);
							}
						}
					}
				}
			}

			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Worklist builder control select button click event handler, calls method to check if unit is valid
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_SelectBtnClicked(object sender, System.EventArgs e)
		{
			try
			{
				BOL.BloodUnit testUnit = null;

				if (this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Available ||
					this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned ||
					this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned ||
					this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Limited)
				{
					//Check the unit for pending transfer status
					if (this.worklistBuilder1.bloodUnitSelector1.BloodUnit.PendingTransferIndicator)
					{
						throw new BOL.BusinessObjectException(string.Format("Unit {0}, {1} is pending transfer and cannot be selected.",this.worklistBuilder1.bloodUnitSelector1.BloodUnit.EyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.ProductType.ProductTypeText));
					}
				}
				else
				{
					throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR33InvalidUnitStatus(this.worklistBuilder1.bloodUnitSelector1.BloodUnit.EyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.ProductType.ProductTypeText, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusText).ResString);
				}

				this._avoidClicking = true;

				testUnit = new BOL.BloodUnit(this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitGuid);
				System.Collections.ArrayList actionList = this._bumControl.ValidateBusinessRules(testUnit, ThisUser);

				if (this._bumControl.IsPool)
				{
					System.Collections.ArrayList poolActionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
					if (actionList.Count > 0)
					{
						if(((Common.ActionItem)actionList[0]).ReturnAction != Common.VerifyAction.Cancel)
						{
							if (poolActionList.Count > 0)
							{
								if(((Common.ActionItem)poolActionList[0]).ReturnAction == Common.VerifyAction.Cancel)
								{
									this.ProcessActionItems(testUnit, poolActionList);
								}
							}
						}
					}

				}				

				this.ProcessActionItems(testUnit, actionList);

				//Create a new blood unit because ProcessActionItems may have altered it
				//Also, since this is a single unit select, update the bloodunitselector so 
				//the worklistbuilder is populated with updated data
				if (this._needsRefresh) 
				{
					testUnit = new BOL.BloodUnit(testUnit.BloodUnitGuid);
					this.worklistBuilder1.bloodUnitSelector1.RefreshBloodUnitData();
				}

				if (this._bumControl.IsPool)
				{
					actionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
					this.ProcessActionItems(testUnit, actionList);

					//ValidateAddingPoolUnit causes no unit changes and so no data refresh is needed
					this._bumControl.AddUnitToPool(testUnit);
				}

					
			}
			catch(Exception err)
			{
				this._avoidClicking = false;

				if (err.Message != string.Empty)		//Validation Messages will be Empty
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
				}
				throw;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Worklist builder search button click event, calls unit search dialog and loads results if applicable
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_SearchClick(object sender, System.EventArgs e)
		{
			BOL.BloodUnit testUnit = null;

			using ( new WaitCursor() ) 
			{
				try
				{
					System.Data.DataTable eligibleUnits = BOL.BloodUnitModification.GetModifiableBloodUnits(this._bumControl.ProductModificationCode, this._bumControl.ModificationMethod, false);
					
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligibleUnits, this.worklistBuilder1.bloodUnitSelector1.EnteredEyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.EnteredUnitProductCode);

					unitSelector.MultiSelect = true;
					unitSelector.TitleBarText = "VBECS - Select Units for Modification";
					unitSelector.LogoBarText = "Select Units for Modification";

					unitSelector.ShowDialogFromLockedParent(this,false);
					
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						this.worklistBuilder1.ResetSelectorFieldsAndErrors();
						foreach (System.Data.DataRow dr in unitSelector.SelectedUnits.Rows) 
						{
							try
							{
								this._avoidClicking = true;

								testUnit = new BOL.BloodUnit(dr);

								System.Collections.ArrayList actionList = this._bumControl.ValidateBusinessRules(testUnit, ThisUser);
					
								if (this._bumControl.IsPool)
								{
									System.Collections.ArrayList poolActionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
									if (actionList.Count > 0)
									{
										if(((Common.ActionItem)actionList[0]).ReturnAction != Common.VerifyAction.Cancel)
										{
											if (poolActionList.Count > 0)
											{
												if(((Common.ActionItem)poolActionList[0]).ReturnAction == Common.VerifyAction.Cancel)
												{
													this.ProcessActionItems(testUnit, poolActionList);
												}
											}
										}
									}
								}

								this.ProcessActionItems(testUnit, actionList);

								//Create a new blood unit because ProcessActionItems may have altered it
								if (this._needsRefresh) testUnit = new BOL.BloodUnit(testUnit.BloodUnitGuid);

								if (this._bumControl.IsPool)
								{
									actionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
									this.ProcessActionItems(testUnit, actionList);

									//ValidateAddingPoolUnit causes no unit changes and so no data refresh is needed
									this._bumControl.AddUnitToPool(testUnit);
								}

								this.worklistBuilder1.PopulateGrid(testUnit);
							}
							catch(Exception err)
							{
								this._avoidClicking = false;
								if (err.Message != string.Empty)	//Validation Msgs are empty
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
								}
							}
						}
					}
				}
				catch (Exception err)
				{
					this._avoidClicking = false;

					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
				}
			}
		}

		/// <summary>
		/// Determines whether a unit was checked/unchecked from the listview of worklistbuilder
		/// </summary>
		/// <param name="sender">Should be the guid of the checked/unchecked item</param>
		/// <param name="e"></param>
		private void worklistBuilder1_ItemCheck(object sender, System.EventArgs e)
		{
			if (this._avoidClicking)
			{
				this._avoidClicking = false;
				return;
			}

			System.Windows.Forms.ItemCheckEventArgs checkArgs = (System.Windows.Forms.ItemCheckEventArgs)e;

			BOL.BloodUnit tmpUnit = (BOL.BloodUnit)sender;
			
			if (checkArgs.NewValue == CheckState.Checked)
			{
				try
				{
					if (this._bumControl.IsPool)
					{
						//Since we're pooling, we need to revalidate the BusinessRules so that 
						//BR_24.18 gets picked up and whatever else may be in there
						System.Collections.ArrayList actionList = this._bumControl.ValidateBusinessRules(tmpUnit, ThisUser);
						System.Collections.ArrayList poolActionList = this._bumControl.ValidateAddingPoolUnit(tmpUnit);

						if (actionList.Count > 0)
						{
							if(((Common.ActionItem)actionList[0]).ReturnAction != Common.VerifyAction.Cancel)
							{
								if (poolActionList.Count > 0)
								{
									if(((Common.ActionItem)poolActionList[0]).ReturnAction == Common.VerifyAction.Cancel)
									{
										this.ProcessActionItems(tmpUnit, poolActionList);
									}
								}
							}
						}

						this.ProcessActionItems(tmpUnit, actionList);

						//Create a new blood unit because ProcessActionItems may have altered it
						//Also, since this is a single unit select, update the bloodunitselector so 
						//the worklistbuilder is populated with updated data
						if (this._needsRefresh) 
						{
							tmpUnit = new BOL.BloodUnit(tmpUnit.BloodUnitGuid);
							this.worklistBuilder1.bloodUnitSelector1.RefreshBloodUnitData();
						}

						actionList = this._bumControl.ValidateAddingPoolUnit(tmpUnit);
						
						this.ProcessActionItems(tmpUnit, actionList);
						
						//ValidateAddingPoolUnit causes no unit changes and so no data refresh is needed
						this._bumControl.AddUnitToPool(tmpUnit);
					}
				}
				catch(Exception err)
				{
					checkArgs.NewValue = CheckState.Unchecked;
					if (err.Message != String.Empty)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
					}
					throw;		//Needed to keep the CheckBox from becoming checked  - Microscoff's fun controls!
				}
			}
			else
			{
				try
				{
					if (this._bumControl.IsPool)
						this._bumControl.RemoveUnitFromPool(tmpUnit.BloodUnitGuid);						
				}
				catch(Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(err.Message));
					checkArgs.NewValue = CheckState.Checked;
				}
			}
			this.CheckValid(this, System.EventArgs.Empty);
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgSelectMultipleUnits_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			
			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.worklistBuilder1.bloodUnitSelector1.GetErrorMessages();
			this.SpeakMessage(textToSpeak);
		}

		#endregion 
	}
}

